<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/api/usage.proto

namespace Google\Api;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Usage configuration rules for the service.
 * NOTE: Under development.
 * Use this rule to configure unregistered calls for the service. Unregistered
 * calls are calls that do not contain consumer project identity.
 * (Example: calls that do not contain an API key).
 * By default, API methods do not allow unregistered calls, and each method call
 * must be identified by a consumer project identity. Use this rule to
 * allow/disallow unregistered calls.
 * Example of an API that wants to allow unregistered calls for entire service.
 *     usage:
 *       rules:
 *       - selector: "*"
 *         allow_unregistered_calls: true
 * Example of a method that wants to allow unregistered calls.
 *     usage:
 *       rules:
 *       - selector: "google.example.library.v1.LibraryService.CreateBook"
 *         allow_unregistered_calls: true
 *
 * Generated from protobuf message <code>google.api.UsageRule</code>
 */
class UsageRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Selects the methods to which this rule applies. Use '*' to indicate all
     * methods in all APIs.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     *
     * Generated from protobuf field <code>string selector = 1;</code>
     */
    private $selector = '';
    /**
     * True, if the method allows unregistered calls; false otherwise.
     *
     * Generated from protobuf field <code>bool allow_unregistered_calls = 2;</code>
     */
    private $allow_unregistered_calls = false;
    /**
     * True, if the method should skip service control. If so, no control plane
     * feature (like quota and billing) will be enabled.
     *
     * Generated from protobuf field <code>bool skip_service_control = 3;</code>
     */
    private $skip_service_control = false;

    public function __construct() {
        \GPBMetadata\Google\Api\Usage::initOnce();
        parent::__construct();
    }

    /**
     * Selects the methods to which this rule applies. Use '*' to indicate all
     * methods in all APIs.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     *
     * Generated from protobuf field <code>string selector = 1;</code>
     * @return string
     */
    public function getSelector()
    {
        return $this->selector;
    }

    /**
     * Selects the methods to which this rule applies. Use '*' to indicate all
     * methods in all APIs.
     * Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
     *
     * Generated from protobuf field <code>string selector = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSelector($var)
    {
        GPBUtil::checkString($var, True);
        $this->selector = $var;

        return $this;
    }

    /**
     * True, if the method allows unregistered calls; false otherwise.
     *
     * Generated from protobuf field <code>bool allow_unregistered_calls = 2;</code>
     * @return bool
     */
    public function getAllowUnregisteredCalls()
    {
        return $this->allow_unregistered_calls;
    }

    /**
     * True, if the method allows unregistered calls; false otherwise.
     *
     * Generated from protobuf field <code>bool allow_unregistered_calls = 2;</code>
     * @param bool $var
     * @return $this
     */
    public function setAllowUnregisteredCalls($var)
    {
        GPBUtil::checkBool($var);
        $this->allow_unregistered_calls = $var;

        return $this;
    }

    /**
     * True, if the method should skip service control. If so, no control plane
     * feature (like quota and billing) will be enabled.
     *
     * Generated from protobuf field <code>bool skip_service_control = 3;</code>
     * @return bool
     */
    public function getSkipServiceControl()
    {
        return $this->skip_service_control;
    }

    /**
     * True, if the method should skip service control. If so, no control plane
     * feature (like quota and billing) will be enabled.
     *
     * Generated from protobuf field <code>bool skip_service_control = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setSkipServiceControl($var)
    {
        GPBUtil::checkBool($var);
        $this->skip_service_control = $var;

        return $this;
    }

}

